//
//  CLMovieDownloadProperties.h
//  mpl
//
//  Created by Emil Pettersson on 13/04/16.
//  Copyright © 2016 Castlabs GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 * Class representing a dictionary of meta-data properties.
 */
@interface CLMovieDownloadProperties : NSObject

/**
 * Source URL for the movie manifest.
 */
@property (nonnull, readonly) NSString* sourceURL;

/**
 * Local URL for the movie manifest.
 */
@property (nonnull, readonly) NSString* localURL;

/**
 * Local URL for the filtered movie manifest.
 */
@property (nullable, readonly) NSString* filteredManifestURL;

/**
 * The movie title (may be nil if not assigned).
 */
@property (nullable, readonly) NSString* title;

/**
 * The total number of downloaded qualities.
 */
@property (readonly) NSUInteger numberOfDownloadedQualities;

/**
 * The number of downloaded video qualities.
 */
@property (readonly) NSUInteger numberOfDownloadedVideoQualities;

/**
 * The number of downloaded audio qualities.
 */
@property (readonly) NSUInteger numberOfDownloadedAudioQualities;

/**
 * The number of downloaded text qualities.
 */
@property (readonly) NSUInteger numberOfDownloadedTextQualities;

/*
 * Get the property object for a given key.
 */
- (nullable id)objectForKey:(nonnull NSString*)key;

@end

#pragma mark -

/**
 * Mutable version of CLMovieDownloadProperties.
 */
@interface CLMutableMovieDownloadProperties : CLMovieDownloadProperties

/**
 * The movie title (may be nil).
 */
@property (nullable) NSString* title;

/*
 * Set the property object for a given key. Note that only JSON compatible objects are supported,
 * i.e. NSNull, NSNumber, NSString, NSArray & NSDictionary.
 */
- (void)setObject:(nonnull id<NSObject>)object forKey:(nonnull NSString*)key;

/*
 * Remove the property object for a given key.
 */
- (void)removeObjectForKey:(nonnull NSString*)key;

@end
