//
//  CLMovieDownloadPropertiesInternal.h
//  mpl
//
//  Created by Emil Pettersson on 13/04/16.
//  Copyright © 2016 Castlabs GmbH. All rights reserved.
//

#import "CLMovieDownloadProperties.h"

FOUNDATION_EXPORT NSString* const _Nonnull CLSourceURLKey;
FOUNDATION_EXPORT NSString* const _Nonnull CLManifestNameKey;
FOUNDATION_EXPORT NSString* const _Nonnull CLTitleKey;
FOUNDATION_EXPORT NSString* const _Nonnull CLNumberOfDownloadedQualitiesKey;
FOUNDATION_EXPORT NSString* const _Nonnull CLNumberOfDownloadedVideoQualitiesKey;
FOUNDATION_EXPORT NSString* const _Nonnull CLNumberOfDownloadedAudioQualitiesKey;
FOUNDATION_EXPORT NSString* const _Nonnull CLNumberOfDownloadedTextQualitiesKey;
FOUNDATION_EXPORT NSString* const _Nonnull CLDownloadedQualityIdentifiersKey;

@interface CLMovieDownloadProperties () {
@protected
    NSString* _localPath;
    NSString* _jsonPath;
    NSMutableDictionary<NSString*, id>* _properties;
}

@property (nullable, readonly) NSArray<NSString*>* downloadedQualityIdentifiers;

+ (nullable instancetype)propertiesWithLocalPath:(nonnull NSString*)localPath
                                     andJSONName:(nonnull NSString*)name;

- (nullable instancetype)initWithLocalPath:(nonnull NSString*)localPath
                               andJSONName:(nonnull NSString*)name;

@end

#pragma mark -

@interface CLMutableMovieDownloadProperties () {
    
}

@property (readwrite) NSUInteger numberOfDownloadedQualities;
@property (readwrite) NSUInteger numberOfDownloadedVideoQualities;
@property (readwrite) NSUInteger numberOfDownloadedAudioQualities;
@property (readwrite) NSUInteger numberOfDownloadedTextQualities;

@property (nullable, readwrite) NSString* filteredManifestURL;

@property (nullable, readwrite) NSArray<NSString*>* downloadedQualityIdentifiers;
@property (nonatomic) BOOL writeQueued;

+ (nullable instancetype)propertiesWithSourceURL:(nonnull NSString*)sourceURL
                                       localPath:(nonnull NSString*)localPath
                                    manifestName:(nonnull NSString*)manifestName
                                     andJSONName:(nonnull NSString*)name;

- (nullable instancetype)initWithSourceURL:(nonnull NSString*)sourceURL
                                 localPath:(nonnull NSString*)localPath
                              manifestName:(nonnull NSString*)manifestName
                               andJSONName:(nonnull NSString*)name;

@end
