//
//  CLQuality.h
//  mpl
//
//  Created by Iskandar Safarov on 6/04/2016.
//  Copyright © 2016 Castlabs GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CLMediaType.h"

@class CLTrack;

/**
 * CLQuality represents single quality of the track to be player/downloaded
 */
@interface CLQuality : NSObject

/**
 * Retrieve parent of track
 */
@property(nullable, readonly, weak) CLTrack *parent;

/**
 * Short textual parameters. E.g. for video it can be "320x240" and for audio it
 * can be "44100 Hz, 16 bit, 2 ch"
 */
@property(nonnull, readonly) NSString *parameters;

/**
 * Track FourCC code which shall be guaranteed to have size of 4.
 * If no FourCC is provided by underlying implementation it shall contain FourCC
 * of the track relevant to its format.
 */
@property(nonnull, readonly) NSString *fourCC;

/**
 * Retrieve type of quality
 */
@property(readonly) CLMediaType type;

/**
 * Retrieve id of quality.
 * In DASH terms corresponds to the RepresentationType::id
 */
@property(nullable, readonly) NSString *identifier;

/**
 * Bitrate of the quality.
 */
@property(readonly) UInt32 bitrate;

@end

#pragma mark -

/**
 * Quality which provides codec-specific information
 */
@interface CLCodecPrivateQuality : CLQuality

/**
 * Retrieve codec-specific private data which might be needed for proper codec
 * initialisation
 */
@property(nullable, readonly) NSData *codecPrivateData;

@end

#pragma mark -

/**
 * Audio quality interface extension
 */
@interface CLAudioQuality : CLCodecPrivateQuality

/**
 * Get number of channels
 */
@property(readonly) UInt32 channels;

/**
 * Get number of samples per second
 */
@property(readonly) UInt32 sampleRate;

/**
 * Get number of bits per sample
 */
@property(readonly) UInt32 bitsPerSample;

@end

#pragma mark -

/**
 * Video quality interface extension
 */
@interface CLVideoQuality : CLCodecPrivateQuality

/**
 * Get video width
 */
@property(readonly) UInt32 width;

/**
 * Get video height
 */
@property(readonly) UInt32 height;

/**
 * Get size of NAL unit if applicable
 */
@property(readonly) UInt32 naluSize;

@end

#pragma mark -

/**
 * Text quality interface extension
 */
@interface CLTextQuality : CLQuality

/**
 * To be discussed
 * Get text width
 */
@property(readonly) UInt32 width;

/**
 * To be discussed
 * Get text height
 */
@property(readonly) UInt32 height;

/**
 * Text contents (if any)
 */
@property(nullable, readonly) NSString *text;

@end

