//
//  GStreamerBackend.h
//  CastlabsGst
//
//  Created by Denis Bobrov on 19/04/2024.
//

#ifndef GStreamerBackend_h
#define GStreamerBackend_h

#import <Foundation/Foundation.h>
#import <CoreMedia/CMFormatDescription.h>
#import <CoreMedia/CMSampleBuffer.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(int, GstOutputType) {
    GstOutputType_VIDEO,
    GstOutputType_AUDIO,
    GstOutputType_NONE
};

typedef NS_ENUM(int, BackendState) {
    BackendState_NULL,
    BackendState_STOPPED,
    BackendState_PAUSED,
    BackendState_PLAYING,
    BackendState_ERROR
};

@protocol GstBackendDelegate

- (void)backendNotifyStateChangeTo:(BackendState)to from:(BackendState)from;

- (void)backendPushFormat:(CMFormatDescriptionRef)format forOutputType:(GstOutputType)type;
- (void)backendPushSample:(CMSampleBufferRef)sample forOutputType:(GstOutputType)type;

@end // @protocol GstBackendDelegate

@interface GstBackend : NSObject

@property (nonatomic, weak) id<GstBackendDelegate> delegate;
@property (readonly) BackendState state;

- (void)open;
- (void)play;
- (void)pause;
- (void)stop;
- (void)close;

@end // @protocol GstBackend

@interface GstGeneralBackend : GstBackend

- (id)initWithDescription:(NSString*)desc;

@end // @interface GstGeneralBackend

@interface GstIAWrapBackend : GstBackend

- (id)initWithHost:(nonnull NSString*)host keyExchangeTimeout:(uint32_t)sec hdcpRxBlob:(nullable NSData*)blob;

@end // @interface GstIAWrapBackend

NS_ASSUME_NONNULL_END

#endif // GStreamerBackend

