//
//  ImagePool.h
 
//
//  Created by James McGill on 01/04/2016.
//  Copyright © 2016 Castlabs. All rights reserved.
//

#ifndef ImagePool_h
#define ImagePool_h

#include "AbstractImagePool.h"
#include <clc/clcByteArray.h>
#include <map>
#include <string>
#include <memory>
#import <UIKit/UIKit.h>

namespace clc {
    namespace http {
        class AbstractClient;
    }
}

namespace timedText {
class SubtitlesPool;

class ImagePool : public AbstractImagePool {
private:
    struct RenderImp;
    std::unique_ptr<RenderImp> m_pImpl;
    std::map<std::string, __strong UIImage*> m_imagePool;

    clc::ByteArray downloadImage(clc::http::AbstractClient& client, const std::string& url);

protected:
    void drawImageFromId(const std::string& imageId, const RectPx& rect) override;
    void drawImageFromURI(const std::string& imageURI, const RectPx& rect) override;

public:
    ImagePool(const SubtitlesPool& pool);
    virtual ~ImagePool();

    ImagePool(const ImagePool&) = delete;
    ImagePool(ImagePool&&) = delete;
    ImagePool& operator=(const ImagePool&) = delete;
    ImagePool& operator=(ImagePool&&) = delete;

    void setContext(CGContextRef context);

    PointPx storeImageFromBase64Data(const std::string& id, const std::string& data) override;
    PointPx storeImageFromBinaryData(const std::string& key, const clc::ByteArray& bytes) override;
    PointPx storeImageFromURI(const std::string& imageURI) override;

// Platform additions
public:
    PointPx storeImageFromNSData(const std::string& key, NSData* data);
};

} // namespace timedText

#endif // ImagePool_h
