//
//  SubtitlesPoolWrapper.h
 
//
//  Created by Guido Parente on 14/01/2016.
//  Copyright © 2016 Castlabs. All rights reserved.
//
#ifndef SUBTITLES_POOL_WRAPPER_H
#define SUBTITLES_POOL_WRAPPER_H

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

enum BridgeSubtitlesFormat {
    SubtitlesFormat_TTML,
    SubtitlesFormat_WEBVTT,
    SubtitlesFormat_SRT,
    SubtitlesFormat_OTHER
};

@interface TextTrackInfo : NSObject

@property enum BridgeSubtitlesFormat format;
@property NSString* displayName;
@property NSString* languageCode;
@property NSURL* _Nullable url;
@property BOOL forced;

@end

@interface SubtitlesPoolWrapper : NSObject

-(void) displayOnlyForcedSubtitles:(bool) val;

-(void) selectTrack:(NSUInteger) index;
-(void) deselectTrack;
-(NSUInteger) numberOfTracks;
-(NSUInteger) currentSelectedTrackIndex;

-(TextTrackInfo* _Nullable) trackInfo:(NSUInteger) index;
-(void) setTrackInfo:(TextTrackInfo* _Nullable) info withIndex:(NSUInteger) index;

-(void) deleteAllTracks;
-(void) deleteLastTrack;
-(NSUInteger) createNewEmptyTrack;
- (void) clearTrackCues:(NSUInteger)trackIdx beforePositionUs:(NSUInteger)timeUs;
-(size_t) getTrackIndexOf:(NSURL*) url;

 -(bool) parseContentAndAddToTrackIdx:(NSUInteger) trackIdx
                           withFormat:(enum BridgeSubtitlesFormat) format
                          withContent:(nonnull NSString*) subtitleContent
                   withImageSourceUrl:(NSURL* _Nullable) imageSourceUrl
                     withTimeOffsetUs:(NSUInteger) timeOffsetUs;

-(NSUInteger) addMp4ImageSourceToExistingTrackIdx:(NSUInteger) trackIdx
                                 withSubSampleIdx:(NSUInteger) subSampleIndex
                                         withData:(NSData*) bytes;

// Used for preview only
-(NSUInteger) firstCuePositionUs:(NSUInteger) trackIdx;

@end

NS_ASSUME_NONNULL_END

#endif //SUBTITLES_POOL_WRAPPER_H
