//
//  FontUtilities.hpp
 
//
//  Created by James McGill on 18/03/2016.
//  Copyright © 2016 Castlabs. All rights reserved.
//

#ifndef FontUtilities_h
#define FontUtilities_h

#import <UIKit/UIKit.h>
#include "SubtitleTypes.h"

namespace timedText {
    class TextSpan;
    class RenderSettings;
};

CGRect rectToNative(const timedText::RectPx& rect);
UIColor* toUIColor(uint32_t color);
uint32_t argbFromUIColor(UIColor *color);

UIFont* buildFont(const timedText::TextSpan& fragment, const timedText::RenderSettings& settings, const timedText::PointPx &containerSize);
NSDictionary* buildFontAttributes(
    UIFont* font,
    const timedText::TextSpan& fragment,
    const timedText::RenderSettings& settings,
    const timedText::PointPx &containerSize);

NSDictionary* buildFontShadowAttributes(
    UIFont* font,
    const timedText::TextSpan& fragment,
    const timedText::RenderSettings& settings,
    const timedText::PointPx &containerSize);

#endif
