//
//  BitstreamUtils.h
//  CastlabsVT
//
//  Created by Luca Niccoli on 15/12/2020.
//

#import <Foundation/Foundation.h>
#import "asl_wrappers.h"
NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(int, BitstreamFormat) {
    BitstreamFormatAnnexB,
    BitstreamFormatLengthPrefixed,
    BitstreamFormatWithADTSHeader,
    BitstreamFormatPlain,
};
@interface BitstreamUtils : NSObject
+ (BitstreamFormat) detectFormatForOutputType:(OutputType) type withSidechannelInfo: (SidechannelInfo*) info;
// Converts data to the bistream format expected by the platform decoder
+ (NSData*) convertToDecoder:(NSData*) data fromFormat:(BitstreamFormat) format;
+ (NSData*) convertAVCDecoderConfigurationRecordFromAnnexBToLengthPrefixed:(NSData*) data;
@end
NS_ASSUME_NONNULL_END
