//
//  CLLog.h

//
//  Created by Luca Niccoli on 09/12/2020.
//  Copyright © 2020 Castlabs. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 Define the logging verbosity
 */
typedef NS_ENUM(int, CLLogLevel) {
  CLLogLevelDebug,
  CLLogLevelError,
  CLLogLevelNone
};

typedef BOOL (^LogTap)(CLLogLevel level, NSString *message);

@interface CLLog : NSObject
@property(class) CLLogLevel level;
@property(class, nullable) LogTap tap;
+ (void)debug:(NSString *)msg;
+ (void)error:(NSString *)msg;
@end

NS_ASSUME_NONNULL_END
